//texture tex0 < string name = "C:\\Active Projects\\eu3\\game\\gfx\\test\\testred.dds"; >;	// Base texture

float4x4 WorldViewProjectionMatrix; 
float Zoom = 1;

sampler BaseTexture  =
sampler_state
{
##	Texture = <tex0>;
	MinFilter = Linear;
	MagFilter = Linear;
	WrapS = Repeat;
	WrapT = Repeat;
};

struct VS_INPUT
{
    float4 vPosition  : POSITION;
    float2 vTexCoord  : TEXCOORD0;
};

struct VS_OUTPUT
{
    float4  vPosition : POSITION;
    float2  vTexCoord : TEXCOORD0;
};


VS_OUTPUT VertexShader_MapWidget(const VS_INPUT v )
{
	VS_OUTPUT Out = (VS_OUTPUT)0;
   	Out.vPosition  = mul(v.vPosition, WorldViewProjectionMatrix );

	float2 TexCoord = v.vTexCoord;
	TexCoord += (-0.5);
	TexCoord /= Zoom;
	TexCoord += 0.5;
	Out.vTexCoord  = TexCoord;

	return Out;
}

float4 PixelShader_MapWidget( VS_OUTPUT v ) : COLOR
{
	float4 OutColor = tex2D( BaseTexture, v.vTexCoord );
	OutColor.a = 0.5;
  	return OutColor;
}

technique MapWidget
{
	pass p0
	{
		BlendEnable = true;
		BlendFunc = int2(SrcAlpha, OneMinusSrcAlpha);

		VertexProgram = compile arbvp1 VertexShader_MapWidget();
		FragmentProgram = compile arbfp1 PixelShader_MapWidget();
	}
}
